//**************************************************************************
//CN[ht@C    1lcd_lib_XC32.c
//̃t@C͌ՓN炳񂪐݌vꂽCCSRpCpt\Cu
// 1lcd_lib.cƂɁAXC32RpCΉŕύX̂łB
//**************************************************************************

///////////////////////////////////////////////
//  t\퐧䃉Cu@for XC32RpC[
//  ֐͈ȉ
//@@lcd_init()    ----- 
//    lcd_cmd(cmd)  ----- R}ho
//    lcd_data(chr) ----- P\o
//    lcd_clear()   ----- S
//@@lcd_str(str*) -----@\	
//////////////////////////////////////////////

#include	"1lcd_lib_XC32.h"

void lcd_delay_us(volatile unsigned int usec)	//1secx֐
{
	volatile int count;

	count = (int)(lcd_Clock/20000000)*usec;

        do      //F@at@200MH (Clock=200000000)
        {       //delay_us(1000)1000.4secA@delay_us(100)100.6secAdelay_us(10)10.5secAdelay_us(1)1.5sec
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");asm("NOP");
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");

                count--;
        }while(count != 0);
        

}

void lcd_delay_ms(volatile unsigned int msec)	//1msecx֐
{
	volatile unsigned int i;
	
	for(i=0; i<msec; i++)
	lcd_delay_us(1000);
}


//////// f[^o̓Tu֐
void lcd_out(volatile char code, volatile char flag)
{
	if(code & 0b10000000)lcd_port_DB7 = 1;	//LCDDB7ւ̏o̓Zbg
	else lcd_port_DB7 = 0;
	if(code & 0b01000000)lcd_port_DB6 = 1;	//LCDDB6ւ̏o̓Zbg
	else lcd_port_DB6 = 0;
	if(code & 0b00100000)lcd_port_DB5 = 1;	//LCDDB5ւ̏o̓Zbg
	else lcd_port_DB5 = 0;
	if(code & 0b00010000)lcd_port_DB4 = 1;	//LCDDBSւ̏o̓Zbg
	else lcd_port_DB4 = 0;

	if (flag == 0)
		lcd_rs = 1;			// \f[^̏ꍇ
	else
		lcd_rs = 0;			// R}hf[^̏ꍇ

        lcd_delay_us(3);		//3secEFCg
//	lcd_delay_us(1);		//1secEFCg
		
	lcd_stb = 1;			// strobe(E) ON@iEnablej
        lcd_delay_us(3);		//3secEFCg
//	lcd_delay_us(1);		// 1sec F strobeM̕

	lcd_stb = 0;			// reset strobe
}

//////// P\֐
void lcd_data(volatile char asci)
{
	lcd_out(asci, 0);		// ʂSrbgo
	lcd_out(asci<<4, 0);	// ʂSrbgo
	lcd_delay_us(50);		//50secEFCg
}

/////// R}ho͊֐
void lcd_cmd(volatile char cmd)
{
	lcd_out(cmd, 1);		// ʂSrbgo
	lcd_out(cmd<<4, 1);		// ʂSrbgo
	if((cmd & 0x03) != 0)	// clear Homȅꍇ
	lcd_delay_ms(2);	//	2msec҂
	else
	lcd_delay_us(50);	//50secEFCg	
}

/////// S֐
void lcd_clear(void)
{
	lcd_cmd(0x01);			// R}ho
}

/////// o͊֐
void lcd_str(char* str)      
{
	while(*str)				//I[ '\0'o܂
	{
		lcd_data(*str);		//@P\
		str++;				//|C^CNg				
	}       
}


/////// ֐
void lcd_init(void)
{
      //LCD|[g: o̓[hݒ
    lcd_port_DB7_ConfigOut();
    lcd_port_DB6_ConfigOut();  
    lcd_port_DB5_ConfigOut();
    lcd_port_DB4_ConfigOut();
    lcd_rs_ConfigOut();
    lcd_stb_ConfigOut();

    //LCD|[gfW^|[gݒ
    lcd_port_DB7_ConfigDigital();
    lcd_port_DB6_ConfigDigital();
    lcd_port_DB5_ConfigDigital();
    lcd_port_DB4_ConfigDigital();
    lcd_rs_ConfigDigital();
    lcd_stb_ConfigDigital();
    
	lcd_delay_ms(20);		//20msecEFCg
	lcd_out(0x30, 1);		// 8bit mode set
	lcd_delay_ms(5);		//5msecEFCg
	lcd_out(0x30, 1);		// 8bit mode set
	lcd_delay_ms(1);		//1msecEFCg
	lcd_out(0x30, 1);		// 8bit mode set
	lcd_delay_ms(1);		//1msecEFCg
	lcd_out(0x20, 1);		// 4bit mode set
	lcd_delay_ms(1);		//1msecEFCg
	lcd_cmd(0x2E);			// DL=0 4bit mode
	lcd_cmd(0x08);			// display off C=D=B=0
	lcd_cmd(0x0D);			// display on C=D=1 B=0
	lcd_cmd(0x06);			// entry I/D=1 S=0
	lcd_cmd(0x02);			// cursor home
}




